﻿/*
Programmer: Richard Lee
This program creates a SAS transport dataset of diet variables
  plus HHX, FMX, and FPX identifier variables from the 2010 NHIS data.
*/

***MODIFY THE PATHS AS APPROPRIATE FOR YOUR LOCAL ENVIRONMENT;
  ***2010 NHIS CANCERXX (Cancer Control Supplement) dataset;
  filename ccs pipe 'gunzip -c /prj/arb/nhis/data/2010/sasdata/cancerxx.v9x.gz';
  
  ***2010 NHIS CANCERXX formats;
  %include '/prj/arb/nhis/data/2010/progs/formats.cancerxx.sas';
  
  ***Cereal name and food code data;
  filename cereal 'cereal.names.by.foodcode.xls';
  
  ***Cereal attributes data;
  filename ntile 'cereal.attributes.by.foodcode.xls';
  
  ***Median portion size data;
  filename af 'portion.size.xls';
  
  ***Estimated regression coefficients;
  filename ce 'regression.coefficients.xls';
  
  ***Output SAS dataset transport file;
  filename out 'nhis2010dietvars.02-05-2013.v9x';
***MODIFY THE PATHS AS APPROPRIATE FOR YOUR LOCAL ENVIRONMENT;



proc cimport file=ccs data=ccs; run;

proc import datafile=cereal
  out=cereal
  dbms=xls
  replace;
  getnames=yes;
run;

proc sort data=cereal;
  by cerealname;
run;

***Merge cereal food codes into the NHIS CCS dataset;
%macro cercodes(cername);
  data cercodes (keep=&cername &cername.code);
    length &cername $75;
    set cereal;
    &cername=cerealname;
    rename foodcode=&cername.code;
  run;
  
  proc sort data=ccs;
    by &cername;
  run;
  
  data ccs;
    merge cercodes ccs(in=ccs);
    by &cername;
    if ccs;
  run;
%mend;

%cercodes(certyp);
%cercodes(certpsp);
%cercodes(certyp3);
%cercodes(certp3sp);

data ccs;
  set ccs;
  
  if certyp='ZZ' then cereal1fc=certpspcode;
  else cereal1fc=certypcode;
  
  if certyp3='ZZ' then cereal2fc=certp3spcode;
  else cereal2fc=certyp3code;
run;

data dtq;
  set ccs;

  ageinyr=age_p;
  gender=sex;

  ***Create numcer to represent the number of cereals provided;
  if cereal1fc=. and cereal2fc=. then numcer=0;
    else if cereal1fc > 0 and cereal2fc > 0 then numcer=2;
    else if cereal1fc > 0 then numcer=1;

  cerealtimes=CEREALNO;
  milktimes=MILKNO;
  sodatimes=SODANO;
  juicetimes=FRJUICNO;
  swcofftimes=COFFEENO;
  frdnktimes=FRTDRNO;
  sprtdnktimes=SPORDRNO;
  fruittimes=FRUITNO;
  saladtimes=SALADNO;
  frfrytimes=FRIESNO;
  othpottimes=POTATONO;
  beanstimes=BEANSNO;
  othvegtimes=OVEGNO;
  pizzatimes=PIZZANO;
  salsatimes=SALSANO;
  tomsaucetimes=TOMSAUNO;
  cheesetimes=CHEESENO;
  wgrbrdtimes=BREADNO;
  brricetimes=BRRICENO;
  candytimes=CANDYNO;
  donuttimes=DONUTNO;
  cookietimes=COOKIENO;
  icecreamtimes=ICECRNO;
  popcorntimes=POPCNNO;

  cerealunit=CEREALTP;
  milkunit=MILKTP;
  sodaunit=SODATP;
  juiceunit=FRJUICTP;
  swcoffunit=COFFEETP;
  frdnkunit=FRTDRTP;
  sprtdnkunit=SPORDRTP;
  fruitunit=FRUITTP;
  saladunit=SALADTP;
  frfryunit=FRIESTP;
  othpotunit=POTATOTP;
  beansunit=BEANSTP;
  othvegunit=OVEGTP;
  pizzaunit=PIZZATP;
  salsaunit=SALSATP;
  tomsauceunit=TOMSAUTP;
  cheeseunit=CHEESETP;
  wgrbrdunit=BREADTP;
  brriceunit=BRRICETP;
  candyunit=CANDYTP;
  donutunit=DONUTTP;
  cookieunit=COOKIETP;
  icecreamunit=ICECRTP;
  popcornunit=POPCNTP;
run;

data dtq;
  set dtq;

  if (18 <= ageinyr <= 27) then agegrp=1;
  else if (28 <= ageinyr <= 37) then agegrp=2;
  else if (38 <= ageinyr <= 47) then agegrp=3;
  else if (48 <= ageinyr <= 57) then agegrp=4;
  else if (58 <= ageinyr <= 67) then agegrp=5;
  else if (68 <= ageinyr <= 77) then agegrp=6;
  else if ageinyr >= 78 then agegrp=7;

  ***Convert frequency responses to daily estimates;
  %macro xpd (qvar,uvar,outv,maxv);
    if (0 <= &qvar <= 99) OR (0 <= &uvar <= 3) then do;
      if &qvar=0 or &uvar=0 then &outv=0;
      else if &uvar=1 then &outv=&qvar;
      else if &uvar=2 then &outv=&qvar/7;
      else if &uvar=3 then &outv=&qvar/30;
    end;

    ***Remove outliers based on NHANES 2009-10 DSQ;
    if &outv > &maxv then &outv=.;
  %mend;

  %xpd(cerealtimes,cerealunit,hccerxpd,7);
  %xpd(milktimes,milkunit,milkxpd,10);
  %xpd(sodatimes,sodaunit,sodaxpd,8);
  %xpd(juicetimes,juiceunit,frtjcxpd,8);
  %xpd(swcofftimes,swcoffunit,swtctxpd,10);
  %xpd(frdnktimes,frdnkunit,frdnkxpd,99);
  %xpd(sprtdnktimes,sprtdnkunit,sprtdnkxpd,99);
  %xpd(fruittimes,fruitunit,fruitxpd,8);
  %xpd(saladtimes,saladunit,saladxpd,5);
  %xpd(frfrytimes,frfryunit,frfryxpd,5);
  %xpd(othpottimes,othpotunit,othpotxpd,3);
  %xpd(beanstimes,beansunit,beanxpd,4);
  %xpd(othvegtimes,othvegunit,othvegxpd,5);
  %xpd(pizzatimes,pizzaunit,pizzaxpd,2);
  %xpd(salsatimes,salsaunit,salsaxpd,3);
  %xpd(tomsaucetimes,tomsauceunit,tomscxpd,2);
  %xpd(cheesetimes,cheeseunit,cheesexpd,6);
  %xpd(wgrbrdtimes,wgrbrdunit,whgbrdxpd,6);
  %xpd(brricetimes,brriceunit,brricexpd,4);
  %xpd(candytimes,candyunit,candyxpd,8);
  %xpd(donuttimes,donutunit,donutxpd,5);
  %xpd(cookietimes,cookieunit,cakexpd,7);
  %xpd(icecreamtimes,icecreamunit,icecrmxpd,5);
  %xpd(popcorntimes,popcornunit,popcornxpd,3);
  
  ***Combine fruit drinks and energy/sport drinks into a single variable;
  energyxpd=frdnkxpd+sprtdnkxpd;
  if energyxpd>7 then energyxpd=.;
run;

proc import datafile=ntile
  out=ntile
  dbms=xls
  replace;
  getnames=yes;
run;

proc sort data=ntile;
  by food_code;
run;

data ntile (keep=cereal1fc cereal2fc hotcold whgnt sugnt calcnt fibnt);
  set ntile;
  by food_code;
  if first.food_code;
  cereal1fc=food_code;
  cereal2fc=food_code;
run;

proc sort data=dtq;
  by cereal1fc;
run;

proc sort data=ntile;
  by cereal1fc;
run;

data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal2fc);
  by cereal1fc;
  if d;

  c1hotcold=hotcold;
  c1whgnt=whgnt;
  c1sugnt=sugnt;
  c1calcnt=calcnt;
  c1fibnt=fibnt;
run;

proc sort data=dtq;
  by cereal2fc;
run;

proc sort data=ntile;
  by cereal2fc;
run;

data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal1fc);
  by cereal2fc;
  if d;

  c2hotcold=hotcold;
  c2whgnt=whgnt;
  c2sugnt=sugnt;
  c2calcnt=calcnt;
  c2fibnt=fibnt;
run;

data dtq;
  set dtq;

  if numcer in (0,1,2) and hccerxpd >= 0 then do;
  hwg1f=0; hwg2f=0; cwg1f=0; cwg2f=0; cwg3f=0; cwg4f=0;
  has1f=0; has2f=0; cas1f=0; cas2f=0; cas3f=0; cas4f=0;
  hcm1f=0; hcm2f=0; hcm3f=0; ccm1f=0; ccm2f=0; ccm3f=0; ccm4f=0;
  hfb1f=0; hfb2f=0; hfb3f=0; cfb1f=0; cfb2f=0; cfb3f=0; cfb4f=0;
  if numcer=1 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+hccerxpd;
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+hccerxpd;
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+hccerxpd;
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+hccerxpd;
   end;
   else if numcer=2 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+(.75*hccerxpd);
    if c2hotcold=2 and c2whgnt=1 then cwg1f=cwg1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=2 then cwg2f=cwg2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=3 then cwg3f=cwg3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=4 then cwg4f=cwg4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=1 then hwg1f=hwg1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=2 then hwg2f=hwg2f+(.25*hccerxpd);
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+(.75*hccerxpd);
    if c2hotcold=2 and c2sugnt=1 then cas1f=cas1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=2 then cas2f=cas2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=3 then cas3f=cas3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=4 then cas4f=cas4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=1 then has1f=has1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=2 then has2f=has2f+(.25*hccerxpd);
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+(.75*hccerxpd);
    if c2hotcold=2 and c2calcnt=1 then ccm1f=ccm1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=2 then ccm2f=ccm2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=3 then ccm3f=ccm3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=4 then ccm4f=ccm4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=1 then hcm1f=hcm1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=2 then hcm2f=hcm2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=3 then hcm3f=hcm3f+(.25*hccerxpd);
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+(.75*hccerxpd);
    if c2hotcold=2 and c2fibnt=1 then cfb1f=cfb1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=2 then cfb2f=cfb2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=3 then cfb3f=cfb3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=4 then cfb4f=cfb4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=1 then hfb1f=hfb1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=2 then hfb2f=hfb2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=3 then hfb3f=hfb3f+(.25*hccerxpd);
    end;
  end;
run;

proc sort data=dtq;
  by gender agegrp;
run;

proc import datafile=af
  out=af
  dbms=xls
  replace;
  getnames=yes;
run;

proc sort data=af;
  by gender agegrp;
run;

data dtq;
  merge dtq (in=d) af;
  by gender agegrp;
  if d;
run;

data dtq;
  set dtq;

  ghcerfib1=hfb1f*gP50hcereal;
  ghcerfib2=hfb2f*gP50hcereal;
  ghcerfib3=hfb3f*gP50hcereal;
  gccerfib1=cfb1f*gP50ccereal;
  gccerfib2=cfb2f*gP50ccereal;
  gccerfib3=cfb3f*gP50ccereal;
  gccerfib4=cfb4f*gP50ccereal;
  gwhgbrd=whgbrdxpd*gP50whgrd;
  gpopcorn=popcornxpd*gP50popcorn;
  gbrownrice=brricexpd*gP50brownrice;
  gcheese=cheesexpd*gP50cheese;
  gpizza=pizzaxpd*gP50pizza;
  gmilk=milkxpd*gP50milk;
  gicecream=icecrmxpd*gP50icecream;
  gregsoda=sodaxpd*gP50regsoda;
  gsportfrdrnk=energyxpd*gP50sportfrdrnk;
  gcookietc=cakexpd*gP50cookietc;
  gdonut=donutxpd*gP50donut;
  gsugincof=swtctxpd*gP50sugincof;
  gcandy=candyxpd*gP50candy;
  gfrtj=frtjcxpd*gP50frtj;
  gfruit=fruitxpd*gP50fruit;
  gsalad=saladxpd*gP50salad;
  gothpot=othpotxpd*gP50othpot;
  gdrbean=beanxpd*gP50drbean;
  gothveg=othvegxpd*gP50othveg;
  gfrfry=frfryxpd*gP50frfry;
  gtomsc=tomscxpd*gP50tomsc;
  gsalsa=salsaxpd*gP50salsa;

  ghcercalc1=hcm1f*gP50hcereal;
  ghcercalc2=hcm2f*gP50hcereal;
  ghcercalc3=hcm3f*gP50hcereal;
  gccercalc1=ccm1f*gP50ccereal;
  gccercalc2=ccm2f*gP50ccereal;
  gccercalc3=ccm3f*gP50ccereal;
  gccercalc4=ccm4f*gP50ccereal;

  shceraddsug1=has1f*sP50hcereal;
  shceraddsug2=has2f*sP50hcereal;
  scceraddsug1=cas1f*sP50ccereal;
  scceraddsug2=cas2f*sP50ccereal;
  scceraddsug3=cas3f*sP50ccereal;
  scceraddsug4=cas4f*sP50ccereal;
  sicecream=icecrmxpd*sP50icecream;
  sregsoda=sodaxpd*sP50regsoda;
  ssportfrdrnk=energyxpd*sP50sportfrdrnk;
  scookietc=cakexpd*sP50cookietc;
  sdonut=donutxpd*sP50donut;
  ssugincof=swtctxpd*sP50sugincof;
  scandy=candyxpd*sP50candy;

  ghcerwg1=hwg1f*gP50hcereal;
  ghcerwg2=hwg2f*gP50hcereal;
  gccerwg1=cwg1f*gP50ccereal;
  gccerwg2=cwg2f*gP50ccereal;
  gccerwg3=cwg3f*gP50ccereal;
  gccerwg4=cwg4f*gP50ccereal;

  dcheese=cheesexpd*dP50cheese;
  dpizza=pizzaxpd*dP50pizza;
  dmilk=milkxpd*dP50milk;
  dicecream=icecrmxpd*dP50icecream;

  vFRTJ=frtjcxpd*vP50FRTJ;
  vFRUIT=fruitxpd*vP50FRUIT;
  vSALAD=saladxpd*vP50SALAD;
  vOTHPOT=othpotxpd*vP50OTHPOT;
  vDRBEAN=beanxpd*vP50DRBEAN;
  vOTHVEG=othvegxpd*vP50OTHVEG;
  vFRFRY=frfryxpd*vP50FRFRY;
  vTOMSC=tomscxpd*vP50TOMSC;
  vSALSA=salsaxpd*vP50SALSA;
  vPIZZA=pizzaxpd*vP50PIZZA;

  ***Sum variables then transform;
  fd8sug=shceraddsug1+shceraddsug2+scceraddsug1+scceraddsug2+scceraddsug3+scceraddsug4+sicecream+
     sregsoda+ssportfrdrnk+scookietc+sdonut+ssugincof+scandy;
  btfd8sug=(fd8sug)**(1/3);
  
  fd10FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vFRFRY+vTOMSC+vSALSA+vPIZZA;
  fd9FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vTOMSC+vSALSA+vPIZZA;
  sqrtfd10fvl=sqrt(fd10FVL);
  sqrtfd9fvl=sqrt(fd9FVL);

  fd2frt=vFRTJ+vFRUIT;
  sqrtfd2frt=(fd2frt)**(1/2);

  fd8veg=vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vFRFRY+vTOMSC+vSALSA+vPIZZA;
  sqrtfd8veg=(fd8veg)**(1/2);

  fd3ssb=sregsoda+ssportfrdrnk+ssugincof;
  sqrtfd3ssb=sqrt(fd3ssb);

  fd4dairy=dcheese+dpizza+dmilk+dicecream;
  sqfd4dairy=sqrt(fd4dairy);
run;

proc sort data=dtq;
  by gender;
run;

proc import datafile=ce
  out=ce
  dbms=xls
  replace;
  getnames=yes;
run;

proc sort data=ce;
  by gender;
run;

data dtq;
  merge dtq (in=d) ce;
  by gender;
  if d;
run;

data dtq (keep = HHX FMX FPX FCE VCE FVCE FVCENoFF Fiber Dairy Calcium Sugar SSB WHGrain);
  set dtq;
  by gender;
  
  FCE=(fintercept + fbeta1*sqrtfd2frt)**2;
  label FCE = 'Cup equivalents of fruits per day';
  
  VCE=(vgintercept + vgbeta1*sqrtfd8veg)**2;
  label VCE = 'Cup equivalents of vegetables per day (including legumes and French fries)';
  
  FVCE=(vintercept + (vbeta1*sqrtfd10fvl ) )**2;
  label FVCE = 'Cup equivalents of fruits and vegetables (including legumes and French fries) per day';

  FVCENoFF=(nintercept + (nbeta1*sqrtfd9fvl ) )**2;
  label FVCENoFF = 'Cup equivalents of fruits and vegetables (including legumes and excluding French fries) per day';

  Fiber=(bintercept +  (ghcerfib1*bghcerfib1) + (ghcerfib2*bghcerfib2) + (ghcerfib3*bghcerfib3) + (gccerfib1*bgccerfib1) +
     (gccerfib2*bgccerfib2) + (gccerfib3*bgccerfib3) + (gccerfib4*bgccerfib4) + (gwhgbrd*bgwhgbrd) + (gbrownrice*bgbrownrice) +
     (gcheese*bgcheese) + (gpizza*bgpizza) + (gmilk*bgmilk) + (gicecream*bgicecream) + (gpopcorn*bgpopcorn) +
     (gregsoda*bgregsoda) + (gsportfrdrnk*bgsportfrdrnk) + (gcookietc*bgcookietc) + (gdonut*bgdonut) + (gsugincof*bgsugincof) + (gcandy*bgcandy) +
     (gFRTJ*bgfrtj) + (gFRUIT*bgfruit) + (gSALAD*bgsalad) + (gOTHPOT*bgothpot) + (gDRBEAN*bgdrbean) +
     (gOTHVEG*bgothveg) + (gFRFRY*bgfrfry) + (gTOMSC*bgtomsc) + (gSALSA*bgsalsa) )**4;
  label Fiber='Fiber (g) per day';
  
  Dairy=(dintercept + (dbeta1*sqfd4dairy ) )**2;
  label Dairy = 'Cup equivalents of dairy per day';

  Calcium=(cintercept + (ghcercalc1*cghcercalc1) + (ghcercalc2*cghcercalc2) + (ghcercalc3*cghcercalc3) + (gccercalc1*cgccercalc1) +
     (gccercalc2*cgccercalc2) + (gccercalc3*cgccercalc3) + (gccercalc4*cgccercalc4) + (gwhgbrd*cgwhgbrd) + (gbrownrice*cgbrownrice) +
     (gcheese*cgcheese) + (gpizza*cgpizza) + (gmilk*cgmilk) + (gicecream*cgicecream) + (gpopcorn*cgpopcorn) +
     (gregsoda*cgregsoda) + (gsportfrdrnk*cgsportfrdrnk) + (gcookietc*cgcookietc) + (gdonut*cgdonut) + (gsugincof*cgsugincof) +  (gcandy*cgcandy) +
     (gFRTJ*cgfrtj) + (gFRUIT*cgfruit) + (gSALAD*cgsalad) + (gOTHPOT*cgothpot) + (gDRBEAN*cgdrbean) +
     (gOTHVEG*cgothveg) + (gFRFRY*cgfrfry) + (gTOMSC*cgtomsc) + (gSALSA*cgsalsa) )**4;
  label Calcium='Calcium (mg) per day';

  Sugar=(wintercept + (wbeta1*btfd8sug ) )**3;
  label Sugar='Added sugars (tsp) per day';

  SSB=(xintercept + (xbeta1*sqrtfd3ssb) )**2;
  label SSB = 'Added sugars (tsp) from sugar-sweetened beverages';
  
  WHGrain=(gintercept + (ghcerwg1*gghcerwg1) + (ghcerwg2*gghcerwg2) + (gccerwg1*ggccerwg1) + (gccerwg2*ggccerwg2)
   + (gccerwg3*ggccerwg3) + (gccerwg4*ggccerwg4) + (gwhgbrd*ggwhgbrd) + (gpopcorn*ggpopcorn) + (gbrownrice*ggbrownrice) )**2;
  label WHGrain = 'Ounce equivalents of whole grains per day';
  
  ***Round diet variables to the nearest 0.000001;
  array diet_vars[*] FCE VCE FVCE FVCENoFF Fiber Dairy Calcium Sugar SSB WHGrain;
  do i = 1 to dim(diet_vars);
    diet_vars[i] = round(diet_vars[i],.000001);
  end;
run;

proc sort data=dtq;
  by HHX FMX FPX;
run;

proc contents data=dtq;
run;

proc cport data=dtq file=out;
run;